/*******************************************************************************
* Copyright 2024-2025 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include "gpu/intel/jit/generator.hpp"

#include "gpu/intel/jit/utils/utils.hpp"
#include "ngen_register_decl.hpp"

namespace dnnl {
namespace impl {
namespace gpu {
namespace intel {
namespace jit {

void check_kernel_size(const std::string &kernel_name, size_t kernel_size,
        size_t icache_size) {
    if (kernel_size > icache_size) {
        gpu_warning() << kernel_name
                      << " larger than icache, kernel: " << kernel_size
                      << " bytes, icache: " << icache_size << " bytes";
    }
}

} // namespace jit
} // namespace intel
} // namespace gpu
} // namespace impl
} // namespace dnnl
