import * as Primitive from "@ot-builder/primitive";
import { OtVar } from "@ot-builder/variance";
export declare const Tag = "OS/2";
export declare enum FsType {
    None = 0,
    InstallableEmbedding = 1,
    RestrictedLicense = 2,
    PreviewPrintLicense = 4,
    EditableEmbedding = 8,
    Reserved4 = 16,
    Reserved5 = 32,
    Reserved6 = 64,
    Reserved7 = 128,
    NoSubsetting = 256,
    BitmapEmbeddingOnly = 512
}
export declare enum FsSelection {
    None = 0,
    ITALIC = 1,
    UNDERSCORE = 2,
    NEGATIVE = 4,
    OUTLINED = 8,
    STRIKEOUT = 16,
    BOLD = 32,
    REGULAR = 64,
    USE_TYPO_METRICS = 128,
    WWS = 256,
    OBLIQUE = 512
}
export declare enum CodePageRange1 {
    None = 0,
    CP1252 = 1,
    CP1250 = 2,
    CP1251 = 4,
    CP1253 = 8,
    CP1254 = 16,
    CP1255 = 32,
    CP1256 = 64,
    CP1257 = 128,
    CP1258 = 256,
    Ansi1 = 512,
    Ansi2 = 1024,
    Ansi3 = 2048,
    Ansi4 = 4096,
    Ansi5 = 8192,
    Ansi6 = 16384,
    Ansi7 = 32768,
    CP874 = 65536,
    CP932 = 131072,
    CP936 = 262144,
    CP949 = 524288,
    CP950 = 1048576,
    CP1361 = 2097152,
    Oem1 = 4194304,
    Oem2 = 8388608,
    Oem3 = 16777216,
    Oem4 = 33554432,
    Oem5 = 67108864,
    Oem6 = 134217728,
    Oem7 = 268435456,
    MacRoman = 536870912,
    Oem = 1073741824,
    Symbol = -2147483648
}
export declare enum CodePageRange2 {
    None = 0,
    Oem8 = 1,
    Oem9 = 2,
    Oem10 = 4,
    Oem11 = 8,
    Oem12 = 16,
    Oem13 = 32,
    Oem14 = 64,
    Oem15 = 128,
    Oem16 = 256,
    Oem17 = 512,
    Oem18 = 1024,
    Oem19 = 2048,
    Oem20 = 4096,
    Oem21 = 8192,
    Oem22 = 16384,
    Oem23 = 32768,
    CP869 = 65536,
    CP866 = 131072,
    CP865 = 262144,
    CP864 = 524288,
    CP863 = 1048576,
    CP862 = 2097152,
    CP861 = 4194304,
    CP860 = 8388608,
    CP857 = 16777216,
    CP855 = 33554432,
    CP852 = 67108864,
    CP775 = 134217728,
    CP737 = 268435456,
    CP708 = 536870912,
    CP850 = 1073741824,
    CP437 = -2147483648
}
export declare enum UnicodeRange1 {
    None = 0,
    BasicLatin = 1,
    Latin1Supplement = 2,
    LatinExtendedA = 4,
    LatinExtendedB = 8,
    Phonetics = 16,
    SpacingModifiers = 32,
    CombiningDiacriticalMarks = 64,
    GreekAndCoptic = 128,
    Coptic = 256,
    Cyrillic = 512,
    Armenian = 1024,
    Hebrew = 2048,
    Vai = 4096,
    Arabic = 8192,
    NKo = 16384,
    Devanagari = 32768,
    Bengali = 65536,
    Gurmukhi = 131072,
    Gujarati = 262144,
    Oriya = 524288,
    Tamil = 1048576,
    Telugu = 2097152,
    Kannada = 4194304,
    Malayalam = 8388608,
    Thai = 16777216,
    Lao = 33554432,
    Georgian = 67108864,
    Balinese = 134217728,
    HangulJamo = 268435456,
    LatinExtendedAdditional = 536870912,
    GreekExtended = 1073741824,
    Punctuations = -2147483648
}
export declare enum UnicodeRange2 {
    None = 0,
    SuperscriptsAndSubscripts = 1,
    CurrencySymbols = 2,
    CombiningDiacriticalMarksForSymbols = 4,
    LetterLikeSymbols = 8,
    NumberForms = 16,
    Arrows = 32,
    MathematicalOperators = 64,
    MiscellaneousTechnical = 128,
    ControlPictures = 256,
    OpticalCharacterRecognition = 512,
    EnclosedAlphanumerics = 1024,
    BoxDrawing = 2048,
    BlockElements = 4096,
    GeometricShapes = 8192,
    MiscellaneousSymbols = 16384,
    Dingbats = 32768,
    CJKSymbolsAndPunctuation = 65536,
    Hiragana = 131072,
    Katakana = 262144,
    Bopomofo = 524288,
    HangulCompatibilityJamo = 1048576,
    Phagspa = 2097152,
    EnclosedCJKLettersAndMonths = 4194304,
    CJKCompatibility = 8388608,
    HangulSyllables = 16777216,
    NonPlane0 = 33554432,
    Phoenician = 67108864,
    CJKUnifiedIdeographs = 134217728,
    PrivateUseAreaP0 = 268435456,
    CJKStrokes = 536870912,
    AlphabeticPresentationForms = 1073741824,
    ArabicPresentationFormsA = -2147483648
}
export declare enum UnicodeRange3 {
    None = 0,
    CombiningHalfMarks = 1,
    VerticalFormsAndCJKCompatibilityForms = 2,
    SmallFormVariants = 4,
    ArabicPresentationFormsB = 8,
    HalfWidthAndFullWidthForms = 16,
    Specials = 32,
    Tibetan = 64,
    Syriac = 128,
    Thaana = 256,
    Sinhala = 512,
    Myanmar = 1024,
    Ethiopic = 2048,
    Cherokee = 4096,
    UnifiedCanadianAboriginalSyllabics = 8192,
    Ogham = 16384,
    Runic = 32768,
    Khmer = 65536,
    Mongolian = 131072,
    BraillePatterns = 262144,
    YiSyllables = 524288,
    Tagalog = 1048576,
    OldItalic = 2097152,
    Gothic = 4194304,
    Deseret = 8388608,
    MusicalSymbols = 16777216,
    MathematicalAlphanumericSymbols = 33554432,
    PrivateUseP15AndP16 = 67108864,
    VariationSelectors = 134217728,
    Tags = 268435456,
    Limbu = 536870912,
    TaiLe = 1073741824,
    NewTaiLue = -2147483648
}
export declare enum UnicodeRange4 {
    None = 0,
    Buginese = 1,
    Glagolitic = 2,
    Tifinagh = 4,
    YijingHexagramSymbols = 8,
    SylotiNagri = 16,
    LinearBSyllabaryIdeogramsAndAegeanNumbers = 32,
    AncientGreekNumbers = 64,
    Ugaritic = 128,
    OldPersian = 256,
    Shavian = 512,
    Osmanya = 1024,
    CypriotSyllabary = 2048,
    Kharoshthi = 4096,
    TaiXuanJingSymbols = 8192,
    Cuneiform = 16384,
    CountingRodNumerals = 32768,
    Sundanese = 65536,
    Lepcha = 131072,
    OlChiki = 262144,
    Saurashtra = 524288,
    KayahLi = 1048576,
    Rejang = 2097152,
    Cham = 4194304,
    AncientSymbols = 8388608,
    PhaistosDisc = 16777216,
    CarianAndLycian = 33554432,
    DominoAndMahjongTiles = 67108864
}
export declare class Panose {
    bFamilyType: Primitive.UInt8;
    bSerifStyle: Primitive.UInt8;
    bWeight: Primitive.UInt8;
    bProportion: Primitive.UInt8;
    bContrast: Primitive.UInt8;
    bStrokeVariation: Primitive.UInt8;
    bArmStyle: Primitive.UInt8;
    bLetterform: Primitive.UInt8;
    bMidline: Primitive.UInt8;
    bXHeight: Primitive.UInt8;
}
export declare class Table {
    readonly version: Primitive.UInt16;
    constructor(version: Primitive.UInt16);
    xAvgCharWidth: Primitive.Int16;
    usWeightClass: Primitive.UInt16;
    usWidthClass: Primitive.UInt16;
    fsType: FsType;
    ySubscriptXSize: OtVar.Value;
    ySubscriptYSize: OtVar.Value;
    ySubscriptXOffset: OtVar.Value;
    ySubscriptYOffset: OtVar.Value;
    ySuperscriptXSize: OtVar.Value;
    ySuperscriptYSize: OtVar.Value;
    ySuperscriptXOffset: OtVar.Value;
    ySuperscriptYOffset: OtVar.Value;
    yStrikeoutSize: OtVar.Value;
    yStrikeoutPosition: OtVar.Value;
    sFamilyClass: Primitive.Int16;
    panose: Panose;
    ulUnicodeRange1: UnicodeRange1;
    ulUnicodeRange2: UnicodeRange2;
    ulUnicodeRange3: UnicodeRange3;
    ulUnicodeRange4: UnicodeRange4;
    achVendID: Primitive.Tag;
    fsSelection: FsSelection;
    usFirstCharIndex: Primitive.UInt16;
    usLastCharIndex: Primitive.UInt16;
    sTypoAscender: OtVar.Value;
    sTypoDescender: OtVar.Value;
    sTypoLineGap: OtVar.Value;
    usWinAscent: OtVar.Value;
    usWinDescent: OtVar.Value;
    ulCodePageRange1: CodePageRange1;
    ulCodePageRange2: CodePageRange2;
    sxHeight: OtVar.Value;
    sCapHeight: OtVar.Value;
    usDefaultChar: Primitive.UInt16;
    usBreakChar: Primitive.UInt16;
    usMaxContext: Primitive.UInt16;
    usLowerOpticalPointSize: Primitive.UInt16;
    usUpperOpticalPointSize: Primitive.UInt16;
}
//# sourceMappingURL=os2.d.ts.map