"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const ava_1 = tslib_1.__importDefault(require("ava"));
const fs = tslib_1.__importStar(require("fs-extra"));
const config_1 = require("../config");
const director_1 = tslib_1.__importDefault(require("../core/director"));
const file_1 = require("../rule-types/file");
const task_1 = require("../rule-types/task");
const test_helper_1 = require("../test-helper");
(0, ava_1.default)("Dynamic dependency test", async (t) => {
    const director = new director_1.default();
    const { dc, fu } = (0, file_1.ImplicitFileRules)(new config_1.VerdaConfig({ rulePath: "./package.json" }), director);
    const { task } = (0, task_1.Task)(director);
    let triggeredRebuild = false;
    const start = task(`start`, async (target) => {
        const list = "payloads/dynamic/list.txt";
        await target.need(fu `payloads/dynamic/list.txt`);
        const lines = (await fs.readFile(list, "utf-8"))
            .split("\n")
            .map(file => fu `payloads/dynamic/${file}`);
        await target.need(...lines);
        triggeredRebuild = true;
    });
    async function rebuild() {
        triggeredRebuild = false;
        await (0, test_helper_1.wait)(100);
        await director.reset();
        await director.want(start);
    }
    await fs.ensureDir("payloads/dynamic");
    await (0, test_helper_1.tamper)("payloads/dynamic/list.txt", "a.txt\nb.txt");
    await (0, test_helper_1.tamper)("payloads/dynamic/a.txt", "a");
    await (0, test_helper_1.tamper)("payloads/dynamic/b.txt", "b");
    await (0, test_helper_1.tamper)("payloads/dynamic/c.txt", "c");
    await rebuild();
    t.is(triggeredRebuild, true);
    await rebuild();
    t.is(triggeredRebuild, false);
    await (0, test_helper_1.tamper)("payloads/dynamic/list.txt", "a.txt\nb.txt\nc.txt");
    await rebuild();
    t.is(triggeredRebuild, true);
    await (0, test_helper_1.tamper)("payloads/dynamic/c.txt", "c");
    await rebuild();
    t.is(triggeredRebuild, false);
    await (0, test_helper_1.tamper)("payloads/dynamic/list.txt", "a.txt\nb.txt");
    await rebuild();
    t.is(triggeredRebuild, true);
    await (0, test_helper_1.tamper)("payloads/dynamic/c.txt", "c");
    await rebuild();
    t.is(triggeredRebuild, false);
    await (0, test_helper_1.tamper)("payloads/dynamic/c.txt", "");
    await rebuild();
    t.is(triggeredRebuild, false);
    await (0, test_helper_1.tamper)("payloads/dynamic/a.txt", "aa");
    await rebuild();
    t.is(triggeredRebuild, true);
    await (0, test_helper_1.tamper)("payloads/dynamic/a.txt", "aa");
    await rebuild();
    t.is(triggeredRebuild, false);
});
