"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AltRun = exports.OptRun = exports.Arg = exports.Param = exports.Option = exports.Cmd = exports.Rule = exports.Bullet = exports.CONSOLE_WIDTH = void 0;
const Chalk = require("chalk");
const terminalSupportsUnicode = process.platform !== "win32" ||
    process.env.TERM_PROGRAM === "vscode" ||
    !!process.env.WT_SESSION; // Workaround https://github.com/microsoft/terminal/issues/1040
exports.CONSOLE_WIDTH = 80;
exports.Bullet = terminalSupportsUnicode ? `· ` : `+ `;
exports.Rule = (terminalSupportsUnicode ? `─` : `-`).repeat(exports.CONSOLE_WIDTH);
exports.Cmd = Chalk.cyan;
exports.Option = Chalk.green;
const Param = (s, ...placeholders) => `<` + Chalk.yellow(s, ...placeholders) + `>`;
exports.Param = Param;
const Arg = (s, ...placeholders) => Chalk.yellow(s, ...placeholders);
exports.Arg = Arg;
function OptRun(...xs) {
    return ["[", ...xs, "]"];
}
exports.OptRun = OptRun;
function AltRun(...xs) {
    const a = [];
    for (let index = 0; index < xs.length; index++) {
        if (index)
            a.push("|");
        a.push(xs[index]);
    }
    return a;
}
exports.AltRun = AltRun;
//# sourceMappingURL=style.js.map