      SUBROUTINE SDPCHB(IOUNIT,AA,BB,N,CL,CU,COND,EREPS,IADAPT)
C***BEGIN PROLOGUE  SDPCHB
C***REFER TO  SPPCG,SCGCHB
C***ROUTINES CALLED  R1MACH
C***REVISION DATE  860715   (YYMMDD)
C***END PROLOGUE  SDPCHB
C
C     THIS SUBROUTINE DYNAMICALLY DETERMINES THE NEW PRECONDITIONING 
C     POLYNOMIAL, C(A).  THIS IS DONE BY DETERMINING THE NEW INTERVAL
C     [AA,BB] OVER WHICH TO DEFINE THE SCALED AND TRANSLATED CHEBYSHEV
C     POLYNOMIAL, P(A).  ONCE WE HAVE P(A), WE DEFINE C(A)A = I-P(A).
C     AA AND BB ARE UPDATED VIA INFORMATION OBTAINED BY SONEST, WHICH
C     RETURNS EGVAL ESTIMATES FOR THE CURRENT PRECONDITIONED SYSTEM,
C     C(A)A.  THESE ESTIMATES ARE MAPPED TO EGVAL ESTIMATES FOR A, AND
C     THEN [AA,BB] IS EXPANDED IF NECESSARY.  IF THE NEW CG CONVERGENCE
C     FACTOR (CF) IS LARGER THAN THE CURRENT CF, THEN THE OLD POLY IS
C     RETAINED AND THE ITERATION RESUMED.  OTHERWISE, THE CG ITERATION
C     IS RESTARTED WITH THE NEW PRECONDITIONER.  (NOTE: N, THE DEGREE
C     OF THE CHEBYSHEV POLY, MUST BE ODD FOR THE ADAPTIVE PROCEDURE TO
C     WORK CORRECTLY.  IF N IS EVEN, THE ROUTINE RETURNS IMMEDIATELY.)
C
CCCCCCIMPLICIT  DOUBLE PRECISION(A-H,O-Z)
C
C***FIRST EXECUTABLE STATEMENT  SDPCHB
 1    CONTINUE
C
C     *** CHECK THAT N IS POSITIVE AND ODD ***
      IF ((N .LE. 0) .OR. (MOD(N,2) .EQ. 0)) THEN
         IADAPT = -1
         RETURN
      END IF
C
C     *** COMPUTE D, C, RECIPN, SQTMEP ***
      D = 0.5D0*(BB+AA)
      C = 0.5D0*(BB-AA)
      RECIPN = 1.0E0/REAL(N)
      SQTMEP = SQRT(R1MACH(4))
C
C     *** CHECK FOR SMALL C (RELATIVE TO D) ***
      IF (C .LE. D*SQTMEP) THEN
C        *** C IS SMALL ***
         TAU = D**N
         IF (CL .GT. 1.0E0) CL = 1.0E0
         IF (CU .LT. 1.0E0) CU = 1.0E0
         AN = D - ((1.0E0-CL)*TAU)**RECIPN
         BN = D + ((CU-1.0E0)*TAU)**RECIPN
         GOTO 20
      END IF
C
C     *** COMPUTE POLY DEVIATION FROM 1 OVER (AA,BB) ***
      G = D/C
      TAU = COSH(N*ALOG(G+SQRT(G*G-1.0E0)))
C
C     *** DETERMINE NEW LEFT ENDPOINT AN ***
      ETA = (1.0E0-CL)*TAU
      IF (ETA .GT. 1.0E0) THEN
C        *** COMPUTE NEW AA ***
         CSHINV = ALOG(ETA + SQRT(ETA*ETA - 1.0E0))
         AN = D - C*COSH(RECIPN*CSHINV)
      ELSE
C        *** USE OLD AA ***
         AN = AA
         CL = (TAU-1.0E0)/TAU
      END IF
C
C     *** DETERMINE NEW RIGHT ENDPOINT BN ***
      ETA = (CU-1.0E0)*TAU
      IF (ETA .GT. 1.0E0) THEN
C        *** COMPUTE NEW BB ***
         CSHINV = ALOG(ETA + SQRT(ETA*ETA - 1.0E0))
         BN = D + C*COSH(RECIPN*CSHINV)
      ELSE
C        *** USE OLD BB ***
         BN = BB
         CU = (TAU+1.0E0)/TAU
      END IF
C
C     *** CHECK FOR NO CHANGE IN ENDPOINTS ***  
 20   IF ((AN .EQ. AA) .AND. (BN .EQ. BB)) THEN
C        *** NO NEW ENDPOINTS; SET IADAPT ***
         IADAPT = 0 
         COND = CU/CL
         CF = (SQRT(COND)-1.0E0) / (SQRT(COND)+1.0E0)
         IF (IOUNIT .GT. 0) WRITE(IOUNIT,30) CF, COND
 30      FORMAT(' THESE CA EIGENVALUES YIELD NO NEW AA OR BB', /,
     2          ' REFINED CF = ', E12.5, ' AND CONDCA = ', E12.5, /)
         RETURN
      END IF
C
C     *** NEW ENDPOINTS: COMPARE CONVERGENCE FACTORS ***
      CONDO = CU/CL
      GN = (BN+AN) / (BN-AN)
      TAUN = COSH(N*ALOG(GN + SQRT(GN*GN -1.0E0)))
      CONDN = (TAUN+1.0E0) / (TAUN-1.0E0)
      CFO = (SQRT(CONDO)-1.0E0) / (SQRT(CONDO)+1.0E0)
      CFN = (SQRT(CONDN)-1.0E0) / (SQRT(CONDN)+1.0E0)
      EPZ = AMAX1(EREPS, SQTMEP)
      TEST = ALOG(EPZ) * (1.0E0/ALOG(CFO) - 1.0E0/ALOG(CFN))
      IF (TEST .LT. 1.0E0) THEN
C        *** RESUME ITERATION WITH OLD AA,BB ***
         IADAPT = 1
         COND = CONDO
         CF = CFO
         IF (IOUNIT .GT. 0) WRITE(IOUNIT,40) AN, BN, CL, CU, CF, COND
 40      FORMAT(' NEW AA = ', E12.5, ' AND NEW BB = ', E12.5, /,
     2          ' CURRENT POLYNOMIAL IS SUPERIOR; RESUME CG' ,/,
     3          ' CURRENT CL = ', E12.5, ' AND CURRENT CU = ', E12.5,/,
     4          ' CURRENT CF = ', E12.5, ' AND CONDCA     = ', E12.5,/)
      ELSE
C        *** RESTART ITERATION WITH NEW AA,BB ***
         IADAPT = 2
         AA = AN
         BB = BN
         CL = (TAUN-1.0E0)/TAUN
         CU = (TAUN+1.0E0)/TAUN
         COND = CONDN
         CF = CFN
         IF (IOUNIT .GT. 0) WRITE(IOUNIT,50) AN, BN, CL, CU, CF, COND
 50      FORMAT(' NEW AA = ', E12.5, ' AND NEW BB = ', E12.5, /,
     2          ' NEW POLYNOMIAL IS SUPERIOR; RESTART CG ', /,
     3          ' NEW CL = ', E12.5, ' AND NEW CU = ', E12.5, /,
     4          ' NEW CF = ', E12.5, ' AND CONDCA = ', E12.5, /)
      END IF    
C
      RETURN
      END
