/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libwpd
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2012 Fridrich Strba (fridrich.strba@bluewin.ch)
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libwpd.sourceforge.net
 */

#ifndef WPXZIPSTREAM_H_INCLUDED
#define WPXZIPSTREAM_H_INCLUDED

#include <vector>
#include <libwpd-stream/libwpd-stream.h>

namespace libebook
{

class WPXZipStream
{
public:
  static bool isZipFile(WPXInputStream *input);

  static WPXInputStream *getSingleSubstream(WPXInputStream *input);

  static WPXInputStream *getSubstream(WPXInputStream *input, const char *name);
};

}

#endif // WPXZIPSTREAM_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
